Rem
Rem $Header: rdbms/demo/rac_wrappers/mtab_routines.sql /main/2 2010/04/22 23:33:33 swshekha Exp $
Rem
Rem mtab_routines.sql
Rem
Rem Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      mtab_routines.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sswaroop    10/27/09 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE PACKAGE maptab_access AS

  PROCEDURE sel_maptab(
              owner        IN  VARCHAR2,
              logical_q    IN  VARCHAR2,
              instance     IN  VARCHAR2,
              phy_queue    OUT VARCHAR2,
              unshrd_flg   OUT NUMBER,
              sharded      OUT BOOLEAN);

  PROCEDURE sel_maptab(
              owner        IN  VARCHAR2,
              phy_qt       IN  VARCHAR2,
              pri_inst     OUT VARCHAR2,
              sec_inst     OUT VARCHAR2,
              sharded      OUT BOOLEAN);
  
  PROCEDURE sel_maptab(
             owner          IN  VARCHAR2,
             queue_table    IN  VARCHAR2,
             unshrd_flg     OUT NUMBER,
             sharded        OUT BOOLEAN);
             
  PROCEDURE qt_arr_sel_maptab(
               owner        IN VARCHAR2,
               queue_table  IN VARCHAR2,
               map_arr      OUT   dbms_aqadm.map_table_arr);

  PROCEDURE qt_arr_sel_maptab(
               owner        IN VARCHAR2,
               queue_table  IN VARCHAR2,
               phyqt_arr    OUT   dbms_aqadm.qt_list);

  PROCEDURE q_arr_sel_maptab( 
               owner        IN VARCHAR2,
               queue        IN VARCHAR2,
               map_arr      OUT   dbms_aqadm.map_table_arr);

  PROCEDURE ins_maptab( 
               schema                IN VARCHAR2,
               logical_qt            IN VARCHAR2,  
               physical_qt           IN VARCHAR2,
               logical_q             IN VARCHAR2,
               physical_q            IN VARCHAR2,
               primary_inst          IN NUMBER,
               secondary_inst        IN NUMBER,
               unshrd_in_progress    IN NUMBER);

  PROCEDURE arr_ins_maptab(
                      map_arr      IN   dbms_aqadm.map_table_arr);

  PROCEDURE upd_maptab(
             owner          IN VARCHAR2,
             logical_q      IN VARCHAR2,
             physical_q     IN VARCHAR2,
             l_qt           IN VARCHAR2,
             phy_qt         IN VARCHAR2); 

  PROCEDURE upd_maptab(
             owner            IN VARCHAR2,
             phy_qt           IN VARCHAR2,
             pri_inst         IN NUMBER,
             sec_inst         IN NUMBER);

  PROCEDURE upd_maptab(
             owner            IN VARCHAR2,
             queue_table      IN VARCHAR2);

  PROCEDURE qt_del_maptab( 
             owner            IN VARCHAR2,
             phy_qt           IN VARCHAR2);

  PROCEDURE qt_bulkdel_maptab(
             owner            IN VARCHAR2, 
             log_qt           IN VARCHAR2);

  PROCEDURE q_del_maptab(
             owner             IN VARCHAR2,
             physical_q        IN VARCHAR2);

  PROCEDURE type_exist(
             type_name    IN  VARCHAR2,
             flg          OUT BOOLEAN);

  PROCEDURE insert_type_table( 
              own_arr         IN  dbms_aqadm.col_tab,
              type_arr        IN dbms_aqadm.col_tab);

  PROCEDURE generate_dbms_aq;

  PROCEDURE generate_prvt_aq;
  
  PROCEDURE pkg_exist( 
               flg  OUT BOOLEAN);  

  PROCEDURE sel_dbatab(
               schema         IN VARCHAR2,
               q_table        IN VARCHAR2,
               tspace_name    OUT VARCHAR2,
               ini_extent     OUT NUMBER,
               nextextent     OUT NUMBER,
               minextent      OUT NUMBER,
               maxextent      OUT NUMBER,
               pct_incr       OUT NUMBER,
               free_list      OUT NUMBER,
               freelist_grps  OUT NUMBER,
               buffer         OUT VARCHAR2); 

END maptab_access;
/

      /* Package to access map table */
CREATE OR REPLACE PACKAGE BODY maptab_access AS

  /* Overloaded procedure to select from map table */
  PROCEDURE sel_maptab(
              owner        IN  VARCHAR2,
              logical_q    IN  VARCHAR2,
              instance     IN  VARCHAR2,
              phy_queue    OUT VARCHAR2,
              unshrd_flg   OUT NUMBER,
              sharded      OUT BOOLEAN) IS

    schema varchar2(30);     

  BEGIN
    select sys_context('userenv','current_user') into schema from dual;
    sharded := TRUE;

    SELECT physical_queue,unshrd_in_progress 
    INTO phy_queue,unshrd_flg
    FROM shrd$_map_table
    WHERE sys.dbms_assert.enquote_literal(schema) = 
          sys.dbms_assert.enquote_literal(owner)
    AND   sys.dbms_assert.enquote_literal(logical_queue) = 
          sys.dbms_assert.enquote_literal(logical_q) 
    AND   primary_inst = instance;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    sharded := FALSE;
    NULL;
  END sel_maptab;

 ----------------------------------------------------------------------------

  PROCEDURE sel_maptab(
              owner        IN  VARCHAR2,
              phy_qt       IN  VARCHAR2,
              pri_inst     OUT VARCHAR2,
              sec_inst     OUT VARCHAR2,
              sharded      OUT BOOLEAN) IS

  BEGIN
    sharded := TRUE;
    SELECT primary_inst, secondary_inst
    INTO pri_inst, sec_inst
    FROM shrd$_map_table
    WHERE sys.dbms_assert.enquote_literal(schema) = 
          sys.dbms_assert.enquote_literal(owner) 
    AND   sys.dbms_assert.enquote_literal(physical_qt) = 
          sys.dbms_assert.enquote_literal(phy_qt);
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    sharded := FALSE;
    NULL;
  END sel_maptab;

 ----------------------------------------------------------------------------

  PROCEDURE sel_maptab(
              owner        IN  VARCHAR2,
              queue_table  IN  VARCHAR2,
              unshrd_flg   OUT NUMBER,
              sharded      OUT BOOLEAN) IS

  BEGIN
    sharded := TRUE;
    SELECT unshrd_in_progress INTO unshrd_flg
    FROM shrd$_map_table
    WHERE sys.dbms_assert.enquote_literal(schema) = 
          sys.dbms_assert.enquote_literal(owner) 
     AND  sys.dbms_assert.enquote_literal(logical_qt) = 
          sys.dbms_assert.enquote_literal(queue_table) 
     AND  ROWNUM = 1;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
    sharded := FALSE;
    NULL;
  END sel_maptab;

-------------------------------------------------------------------------------

  PROCEDURE qt_arr_sel_maptab(
               owner        IN VARCHAR2,
               queue_table  IN VARCHAR2,
               map_arr      OUT   dbms_aqadm.map_table_arr) IS

    CURSOR qtable_cur IS
       SELECT * FROM shrd$_map_table
       WHERE sys.dbms_assert.enquote_literal(schema) = 
             sys.dbms_assert.enquote_literal(owner) 
        AND  sys.dbms_assert.enquote_literal(logical_qt) = 
             sys.dbms_assert.enquote_literal(queue_table); 

  BEGIN
    OPEN qtable_cur;
    FETCH qtable_cur BULK COLLECT INTO map_arr;
    CLOSE qtable_cur;
  END qt_arr_sel_maptab;

-------------------------------------------------------------------------------

  PROCEDURE qt_arr_sel_maptab(
               owner        IN VARCHAR2,
               queue_table  IN VARCHAR2,
               phyqt_arr    OUT   dbms_aqadm.qt_list) IS

    CURSOR qtable_cur IS
       SELECT distinct physical_qt FROM shrd$_map_table
       WHERE sys.dbms_assert.enquote_literal(schema) = 
             sys.dbms_assert.enquote_literal(owner) 
        AND  sys.dbms_assert.enquote_literal(logical_qt) = 
             sys.dbms_assert.enquote_literal(queue_table);

  BEGIN
    OPEN qtable_cur;

    FETCH qtable_cur BULK COLLECT INTO phyqt_arr;
    CLOSE qtable_cur;

  END qt_arr_sel_maptab;

 ----------------------------------------------------------------------------

  PROCEDURE q_arr_sel_maptab( 
                 owner        IN  VARCHAR2,
                 queue        IN  VARCHAR2,
                 map_arr      OUT dbms_aqadm.map_table_arr) IS

    CURSOR queue_cur IS
       SELECT * FROM shrd$_map_table
       WHERE sys.dbms_assert.enquote_literal(logical_queue) = 
             sys.dbms_assert.enquote_literal(queue) 
        and  sys.dbms_assert.enquote_literal(schema) = 
             sys.dbms_assert.enquote_literal(owner);

  BEGIN
    OPEN queue_cur;
    FETCH queue_cur BULK COLLECT INTO map_arr;
    CLOSE queue_cur;
  END q_arr_sel_maptab;

 ----------------------------------------------------------------------------

  /* Insert procedure for map table */
  PROCEDURE ins_maptab( 
                schema                IN VARCHAR2,
                logical_qt            IN VARCHAR2, 
                physical_qt           IN VARCHAR2,
                logical_q             IN VARCHAR2,
                physical_q            IN VARCHAR2,
                primary_inst          IN NUMBER,
                secondary_inst        IN NUMBER,
                unshrd_in_progress    IN NUMBER) IS
  BEGIN
      INSERT INTO shrd$_map_table
      VALUES(schema, logical_qt, physical_qt, logical_q, physical_q,
      primary_inst, secondary_inst, unshrd_in_progress);
      COMMIT;
  END ins_maptab;
 
 ----------------------------------------------------------------------------

  PROCEDURE arr_ins_maptab(map_arr  IN dbms_aqadm.map_table_arr) IS

  BEGIN
     FORALL indx IN map_arr.FIRST..map_arr.LAST
	INSERT INTO shrd$_map_table
	VALUES(map_arr(indx).schema, map_arr(indx).logical_qt,
	       map_arr(indx).physical_qt, map_arr(indx).logical_queue,
	       map_arr(indx).physical_queue, map_arr(indx).primary_inst,
	       map_arr(indx).secondary_inst, map_arr(indx).unshrd_in_progress);
      COMMIT;
  END arr_ins_maptab;
 
 ----------------------------------------------------------------------------

  /* Update procedure for map table */
  PROCEDURE upd_maptab(
             owner            IN VARCHAR2,
             logical_q        IN VARCHAR2,
             physical_q       IN VARCHAR2,
             l_qt             IN VARCHAR2,
             phy_qt           IN VARCHAR2) IS

  BEGIN
    UPDATE shrd$_map_table 
    SET logical_queue = logical_q, physical_queue = physical_q 
    WHERE sys.dbms_assert.enquote_literal(owner) = 
          sys.dbms_assert.enquote_literal(schema) 
     AND  sys.dbms_assert.enquote_literal(logical_qt) = 
          sys.dbms_assert.enquote_literal(l_qt) 
     AND  sys.dbms_assert.enquote_literal(physical_qt) = 
          sys.dbms_assert.enquote_literal(phy_qt);
    COMMIT;
  END upd_maptab;

 ----------------------------------------------------------------------------

  PROCEDURE upd_maptab(
             owner           IN VARCHAR2,
             phy_qt          IN VARCHAR2,
             pri_inst        IN NUMBER,
             sec_inst        IN NUMBER) IS
  
  BEGIN
    UPDATE shrd$_map_table 
    SET primary_inst = pri_inst, secondary_inst = sec_inst
    WHERE sys.dbms_assert.enquote_literal(schema) = 
          sys.dbms_assert.enquote_literal(owner) 
     AND  sys.dbms_assert.enquote_literal(physical_qt) = 
          sys.dbms_assert.enquote_literal(phy_qt);
    COMMIT;
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
    RAISE_APPLICATION_ERROR(-20051,
                  'More than one shards of a queue table in an instance');
  END upd_maptab;

  ----------------------------------------------------------------------------

  PROCEDURE upd_maptab(
             owner            IN VARCHAR2,
             queue_table      IN VARCHAR2) IS

  BEGIN
    UPDATE shrd$_map_table
    SET unshrd_in_progress = 1
    WHERE sys.dbms_assert.enquote_literal(schema) = 
          sys.dbms_assert.enquote_literal(owner) 
     AND  sys.dbms_assert.enquote_literal(logical_qt) = 
          sys.dbms_assert.enquote_literal(queue_table);
    COMMIT;
  END upd_maptab;
 
 ----------------------------------------------------------------------------

  /* Procedure to delete rows from map table */
  PROCEDURE qt_del_maptab(
             owner        IN VARCHAR2, 
             phy_qt        IN VARCHAR2) IS

  BEGIN
     delete from shrd$_map_table
          where sys.dbms_assert.enquote_literal(schema) = 
                sys.dbms_assert.enquote_literal(owner) 
           AND  sys.dbms_assert.enquote_literal(physical_qt) = 
                sys.dbms_assert.enquote_literal(phy_qt);
     commit;
  END qt_del_maptab;

  ----------------------------------------------------------------------------

  PROCEDURE qt_bulkdel_maptab(
             owner        IN VARCHAR2, 
             log_qt        IN VARCHAR2) IS

  BEGIN
     delete from shrd$_map_table
          where sys.dbms_assert.enquote_literal(schema) = 
                sys.dbms_assert.enquote_literal(owner) 
           AND  sys.dbms_assert.enquote_literal(logical_qt) = 
                sys.dbms_assert.enquote_literal(log_qt);
     commit;
  END qt_bulkdel_maptab;

----------------------------------------------------------------------------
  PROCEDURE q_del_maptab(
             owner             IN VARCHAR2,
             physical_q        IN VARCHAR2) IS

  BEGIN
     delete from shrd$_map_table
          where sys.dbms_assert.enquote_literal(schema) = 
                sys.dbms_assert.enquote_literal(owner)
           AND  sys.dbms_assert.enquote_literal(physical_q) = 
                sys.dbms_assert.enquote_literal(physical_q);
     commit;
  END q_del_maptab;

-------------------------------------------------------------------------------

  /* Generate enqueue and dequeue procedures for RAW payload type at 
     run-time */
  PROCEDURE append_to_clob(v_clob       IN OUT CLOB,
                      pkg               IN     BOOLEAN) IS

  buffer   VARCHAR2(32767);
  
  BEGIN

    IF(pkg = TRUE) THEN

        buffer := '  procedure enqueue(
        queue_name          in  varchar2,
        enqueue_options     in  enqueue_options_t,
        message_properties  in  message_properties_t,
        payload             in  raw,
        msgid               out raw);

        procedure dequeue(
        queue_name           in     varchar2,
        dequeue_options      in     dequeue_options_t,
        message_properties   out    message_properties_t,
        payload              out    raw,
        msgid                out    raw);';

     dbms_lob.writeappend(v_clob, length(buffer), buffer);
    ELSE

        buffer := '  PROCEDURE enqueue(
        queue_name          in  varchar2,
        enqueue_options     in  enqueue_options_t,
        message_properties  in  message_properties_t,
        payload             in  raw,
        msgid               out raw) IS

          canon_q_name         varchar2(30);
          canon_q_schema       varchar2(30);
          eopt                 sys.dbms_aq.enqueue_options_t;
          mprop                sys.dbms_aq.message_properties_t;
          phyq                 varchar2(30);
          qname                varchar2(65);
          uflg                 number;
          sharded              boolean := TRUE;
        BEGIN
          dbms_aqadm.parse_name(queue_name, canon_q_schema, canon_q_name);
          
          maptab_access.sel_maptab(canon_q_schema,
                                   canon_q_name,
                                   current_inst,
                                   phyq,
                                   uflg,
                                   sharded);

          copy_types_enqopt(enqueue_options, eopt);
          copy_types_enqmprop(message_properties, mprop);

          IF (sharded = TRUE and uflg = 0) THEN
          qname := sys.dbms_assert.enquote_name(canon_q_schema, FALSE) || ''.'' ||
                             sys.dbms_assert.enquote_name(phyq, FALSE);
          ELSE
          qname := queue_name;
          END IF;

          sys.dbms_aq.enqueue(
                     queue_name                => qname,
                     enqueue_options           => eopt,
                     message_properties        => mprop,
                     payload                   => payload,
                     msgid                     => msgid);

        END enqueue;

        PROCEDURE dequeue(
                     queue_name           in         varchar2,
                     dequeue_options      in         dequeue_options_t,
                     message_properties   out        message_properties_t,
                     payload              out        raw,
                     msgid                out        raw) IS

        canon_q_name         varchar2(30);
        canon_q_schema       varchar2(30);
        deopt                sys.dbms_aq.dequeue_options_t;
        mprop                sys.dbms_aq.message_properties_t;
        phyq                 varchar2(30);
        qname                varchar2(65);
        uflg                 number;
        sharded              boolean:= TRUE;

        BEGIN
          dbms_aqadm.parse_name(queue_name, canon_q_schema, canon_q_name);
 
          maptab_access.sel_maptab(canon_q_schema,
                                     canon_q_name,
                                     current_inst,
                                     phyq,
                                     uflg,
                                     sharded);

      copy_types_deqopt(dequeue_options, deopt);

      IF (sharded = TRUE) THEN
        qname := sys.dbms_assert.enquote_name(canon_q_schema, FALSE) || ''.'' ||
                             sys.dbms_assert.enquote_name(phyq, FALSE);
      ELSE
        qname := queue_name;
      END IF;

      sys.dbms_aq.dequeue(
        queue_name         => qname,
        dequeue_options    => deopt,
        message_properties => mprop,
        payload            => payload,
        msgid              => msgid);

      copy_types_deqmprop(mprop, message_properties);

  END dequeue;' ;
    dbms_lob.writeappend(v_clob, length(buffer), buffer); 
    END IF; 
  EXCEPTION
    WHEN OTHERS THEN 
    RAISE;
  END append_to_clob;


  /* internal procedure for generating enq/deq procedures of ADT payload */
  PROCEDURE append_to_clob(v_clob       IN OUT CLOB,
                      schema            IN     VARCHAR2, 
                      object_type       IN     VARCHAR2,
                      pkg               IN     BOOLEAN) IS

  buffer   VARCHAR2(32767);
  pload    VARCHAR2(65); 
  BEGIN

   pload := sys.dbms_assert.enquote_name(schema, FALSE) ||'.'||
                     sys.dbms_assert.enquote_name(object_type, FALSE) ;
    IF(pkg = TRUE) THEN
        buffer := '    procedure enqueue(
        queue_name           in    varchar2,
        enqueue_options      in    enqueue_options_t,
        message_properties   in    message_properties_t,
        payload              in    '|| pload|| ', 
        msgid                out   raw);

        procedure dequeue(
        queue_name           in    varchar2,
        dequeue_options      in    dequeue_options_t,
        message_properties   out   message_properties_t,
        payload              out   '|| pload || ',
        msgid                out   raw);';

      dbms_lob.writeappend(v_clob, length(buffer), buffer);
    ELSE
      buffer := '  PROCEDURE enqueue(
        queue_name          in  varchar2,
        enqueue_options     in  enqueue_options_t,
        message_properties  in  message_properties_t,
        payload             in  '|| pload || ', 
        msgid               out raw) IS

        schema  varchar2(30); 
        canon_q_name         varchar2(30);
        canon_q_schema       varchar2(30);
        eopt                 sys.dbms_aq.enqueue_options_t;
        mprop                sys.dbms_aq.message_properties_t;
        phyq                 varchar2(30);
        qname                varchar2(65);
        uflg                 number;
        sharded              boolean := TRUE;
        len  number;

     BEGIN
        dbms_aqadm.parse_name(queue_name, canon_q_schema, canon_q_name);
        --dbms_output.put_line(''curr_instance:'' || current_inst);
        maptab_access.sel_maptab(canon_q_schema, 
                                   canon_q_name,
                                   current_inst,
                                   phyq,
                                   uflg,
                                   sharded);

        copy_types_enqopt(enqueue_options, eopt);
        copy_types_enqmprop(message_properties, mprop);

        IF (sharded = TRUE and uflg = 0) THEN
           qname := sys.dbms_assert.enquote_name(canon_q_schema, FALSE) || ''.'' || 
                             sys.dbms_assert.enquote_name(phyq, FALSE);
        ELSE
          qname := queue_name;
        END IF;
        --dbms_output.put_line(''enq into qname:'' || qname);
        sys.dbms_aq.enqueue (
        queue_name                => qname,
        enqueue_options           => eopt,
        message_properties        => mprop,
        payload                   => payload,
        msgid                     => msgid);
       
   END;  

   PROCEDURE dequeue(
        queue_name           in    varchar2,
        dequeue_options      in    dequeue_options_t,
        message_properties   out   message_properties_t,
        payload              out   '|| pload || ', 
        msgid                out   raw) IS

        canon_q_name         varchar2(30);
        canon_q_schema       varchar2(30);
        deopt                sys.dbms_aq.dequeue_options_t;
        mprop                sys.dbms_aq.message_properties_t;
        phyq                 varchar2(30);
        qname                varchar2(65);
        uflg                 number;
        sharded              boolean:= TRUE;

   BEGIN
     dbms_aqadm.parse_name(queue_name, canon_q_schema, canon_q_name);
     maptab_access.sel_maptab(canon_q_schema, 
                                   canon_q_name,
                                   current_inst,
                                   phyq,
                                   uflg,
                                   sharded);

     copy_types_deqopt(dequeue_options, deopt);

     if (sharded = TRUE) then
       qname := sys.dbms_assert.enquote_name(canon_q_schema, FALSE) || ''.'' || 
                          sys.dbms_assert.enquote_name(phyq, FALSE);
     else
       qname := queue_name;
     end if;

     --dbms_output.put_line('' dequeing from qname:'' || qname);
     sys.dbms_aq.dequeue(
        queue_name          =>  qname,
        dequeue_options     =>  deopt,
        message_properties  =>  mprop,
        payload             =>  payload,
        msgid               =>  msgid);

     copy_types_deqmprop(mprop, message_properties);
   END dequeue; ';
 
    dbms_lob.writeappend(v_clob, length(buffer), buffer);

    END IF; 
  EXCEPTION
    WHEN OTHERS THEN 
    RAISE;
  END append_to_clob;

 ------------------------------------------------------------------------------
  /* Procedure to check whether a given type exists in the shrd$_type_table */

  PROCEDURE type_exist(
             type_name    IN  VARCHAR2,
             flg          OUT BOOLEAN) IS

     l_exist   NUMBER;

  BEGIN
    SELECT count(*) into l_exist 
    from shrd$_type_table 
    where sys.dbms_assert.enquote_literal(schema||'.'||payload_type)  = 
          sys.dbms_assert.enquote_literal(type_name);

    IF(l_exist = 0 ) THEN
      flg := FALSE;
    ELSE
      flg := TRUE;
   END IF;
   
  END type_exist; 

 -------------------------------------------------------------------------------
 /* Insert new payload types into shrd$_type_table */

  PROCEDURE insert_type_table(
                own_arr         IN  dbms_aqadm.col_tab,
                type_arr        IN  dbms_aqadm.col_tab) IS

  BEGIN
    FOR indx IN own_arr.FIRST..own_arr.LAST LOOP
      BEGIN
        insert into shrd$_type_table values(own_arr(indx), type_arr(indx));
      EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
        commit;
      END;
    END LOOP;
    commit;

  END insert_type_table;

 ------------------------------------------------------------------------------
   /* Generate dbms_aq package with enq/deq procedures for all types 
       present in shrd$_type_table */

  PROCEDURE generate_dbms_aq IS
              v_clob           CLOB;
              buffer           VARCHAR2(32767);

     CURSOR type_cur IS
        SELECT * 
        FROM shrd$_type_table;
   
  BEGIN
    dbms_lob.createtemporary(v_clob,true);
    dbms_lob.open(v_clob, dbms_lob.lob_readwrite);
    buffer := ' CREATE OR REPLACE PACKAGE dbms_aq_wrapper AUTHID CURRENT_USER AS

    NAMESPACE_ANONYMOUS CONSTANT BINARY_INTEGER := 0;
    NAMESPACE_AQ        CONSTANT BINARY_INTEGER := 1;
    NAMESPACE_DBCHANGE CONSTANT BINARY_INTEGER := 2;

    NTFN_QOS_RELIABLE        CONSTANT BINARY_INTEGER := 1;
    NTFN_QOS_PAYLOAD         CONSTANT BINARY_INTEGER := 2;
    NTFN_QOS_REPLICATE       CONSTANT BINARY_INTEGER := 4;
    NTFN_QOS_SECURE          CONSTANT BINARY_INTEGER := 8;
    NTFN_QOS_PURGE_ON_NTFN   CONSTANT BINARY_INTEGER := 16;
    NTFN_QOS_MULTICBK        CONSTANT BINARY_INTEGER := 32;

    NTFN_GROUPING_CLASS_TIME CONSTANT BINARY_INTEGER := 1;

    NTFN_GROUPING_TYPE_SUMMARY CONSTANT BINARY_INTEGER := 1;
    NTFN_GROUPING_TYPE_LAST    CONSTANT BINARY_INTEGER := 2;

    NTFN_GROUPING_FOREVER CONSTANT BINARY_INTEGER := -1;

    NOTIFICATION_SUBSCRIBER  CONSTANT BINARY_INTEGER := 16;
			PUBLIC_SUBSCRIBER        CONSTANT BINARY_INTEGER := 32;

    IMMEDIATE           CONSTANT BINARY_INTEGER := 1;
    ON_COMMIT           CONSTANT BINARY_INTEGER := 2;

    BROWSE              CONSTANT BINARY_INTEGER := 1;
    LOCKED              CONSTANT BINARY_INTEGER := 2;
    REMOVE              CONSTANT BINARY_INTEGER := 3;
    REMOVE_NODATA       CONSTANT BINARY_INTEGER := 4;
    GET_SIGNATURE       CONSTANT BINARY_INTEGER := 5;


    FIRST_MESSAGE             CONSTANT BINARY_INTEGER := 1;
    FIRST                     CONSTANT BINARY_INTEGER := 1;
    FIRST_MESSAGE_ONE_GROUP   CONSTANT BINARY_INTEGER := 1;
    FIRST_MESSAGE_MULTI_GROUP CONSTANT BINARY_INTEGER := 4;
    NEXT_MESSAGE              CONSTANT BINARY_INTEGER := 3;
    NEXT                      CONSTANT BINARY_INTEGER := 3;
    NEXT_MESSAGE_ONE_GROUP    CONSTANT BINARY_INTEGER := 3;
    NEXT_MESSAGE_MULTI_GROUP  CONSTANT BINARY_INTEGER := 5;
    NEXT_TRANSACTION          CONSTANT BINARY_INTEGER := 2;
						
    WAITING             CONSTANT BINARY_INTEGER := 1;
    READY               CONSTANT BINARY_INTEGER := 0;
    PROCESSED           CONSTANT BINARY_INTEGER := 2;
    EXPIRED             CONSTANT BINARY_INTEGER := 3;
    SPILLED             CONSTANT BINARY_INTEGER := 7;
    DEFERRED            CONSTANT BINARY_INTEGER := 8;
    DEFRSPIL            CONSTANT BINARY_INTEGER := 9;
    BUFFERED_EXPIRED    CONSTANT BINARY_INTEGER := 10; 

    BEFORE              CONSTANT BINARY_INTEGER := 2;
    TOP                 CONSTANT BINARY_INTEGER := 3;

    FOREVER             CONSTANT BINARY_INTEGER := -1;
    NO_WAIT             CONSTANT BINARY_INTEGER := 0;

    NO_DELAY            CONSTANT BINARY_INTEGER := 0;

    NEVER               CONSTANT BINARY_INTEGER := -1;

    OBJECT_TYPE         CONSTANT BINARY_INTEGER := 1;
    RAW_TYPE            CONSTANT BINARY_INTEGER := 2;

    BUFFERED_MESSAGE    CONSTANT BINARY_INTEGER := 1;

    PERSISTENT               CONSTANT BINARY_INTEGER := 1;
    BUFFERED                 CONSTANT BINARY_INTEGER := 2;
    PERSISTENT_OR_BUFFERED   CONSTANT BINARY_INTEGER := 3;

    JMS_TEXT_MESSAGE   CONSTANT BINARY_INTEGER := 0;
    JMS_BYTES_MESSAGE  CONSTANT BINARY_INTEGER := 1;
    JMS_STREAM_MESSAGE CONSTANT BINARY_INTEGER := 2;
    JMS_MAP_MESSAGE    CONSTANT BINARY_INTEGER := 3;
    JMS_OBJECT_MESSAGE CONSTANT BINARY_INTEGER := 4;

    TYPE aq$_recipient_list_t IS TABLE OF sys.aq$_agent
          INDEX BY BINARY_INTEGER;

    TYPE aq$_agent_list_t IS TABLE OF sys.aq$_agent INDEX BY BINARY_INTEGER;

    TYPE message_properties_t IS
         RECORD(
               priority          binary_integer NOT NULL DEFAULT 1,
               delay             binary_integer NOT NULL DEFAULT NO_DELAY,
               expiration        binary_integer NOT NULL DEFAULT NEVER,
               correlation       varchar2(128) DEFAULT NULL,
               attempts          binary_integer,
               recipient_list    aq$_recipient_list_t,
               exception_queue   varchar2(61) DEFAULT NULL,
               enqueue_time      date,
               state             binary_integer,
               sender_id         sys.aq$_agent DEFAULT NULL,
               original_msgid    raw(16)       DEFAULT NULL,
               signature         sys.aq$_sig_prop  DEFAULT NULL,
               transaction_group varchar2(30)  DEFAULT NULL,
               user_property     sys.anydata   DEFAULT NULL,
               delivery_mode     pls_integer   NOT NULL DEFAULT PERSISTENT);


    TYPE message_properties_array_t IS VARRAY(2147483647) 
         OF message_properties_t;

    TYPE error_info_t IS RECORD (
               error_position    NUMBER,
               error_no          NUMBER,
               error_msg         VARCHAR2(4000));


    TYPE error_array_t IS VARRAY(2147483647) of error_info_t;

    TYPE msgid_array_t IS VARRAY(2147483647)  OF RAW(16);
			
    TYPE enqueue_options_t IS
         RECORD(
               visibility          binary_integer NOT NULL DEFAULT ON_COMMIT,
               relative_msgid      raw(16)  DEFAULT NULL,
               sequence_deviation  binary_integer DEFAULT NULL,
               transformation      varchar2(61) DEFAULT NULL,
               bufmesg_prop        binary_integer DEFAULT NULL,
               delivery_mode     pls_integer   NOT NULL DEFAULT PERSISTENT);

    TYPE dequeue_options_t IS
        RECORD(
                consumer_name     varchar2(30) DEFAULT NULL,
                dequeue_mode      binary_integer NOT NULL DEFAULT REMOVE,
                navigation        binary_integer NOT NULL DEFAULT NEXT_MESSAGE,
                visibility        binary_integer NOT NULL DEFAULT ON_COMMIT,
                wait              binary_integer NOT NULL DEFAULT FOREVER,
                msgid             raw(16)                 DEFAULT NULL,
                correlation       varchar2(128)           DEFAULT NULL,
                deq_condition     varchar2(4000)          DEFAULT NULL,
                signature         sys.aq$_sig_prop        DEFAULT NULL,
                transformation    varchar2(61)            DEFAULT NULL,
                bufmesg_prop      binary_integer          DEFAULT NULL,
                delivery_mode     pls_integer   NOT NULL  DEFAULT PERSISTENT);
   
    procedure listen(
        agent_list           in       aq$_agent_list_t,
        wait                 in       binary_integer DEFAULT FOREVER,
        agent                out      sys.aq$_agent);

    procedure listen(
        agent_list            in       aq$_agent_list_t,
        wait                  in       binary_integer DEFAULT FOREVER,
        listen_delivery_mode  in       pls_integer DEFAULT PERSISTENT,
        agent                 out      sys.aq$_agent,
        message_delivery_mode out      pls_integer);

    procedure bind_agent(
            agent                in    sys.aq$_agent,
            certificate_location in    varchar2 default NULL);

    procedure unbind_agent(
            agent                in   sys.aq$_agent);

    procedure register(
           reg_list      IN       sys.aq$_reg_info_list,
           reg_count     IN       number);

    procedure unregister(
           reg_list      IN       sys.aq$_reg_info_list,
           reg_count     IN       number);

    procedure post(
           post_list     IN       sys.aq$_post_info_list,
           post_count    IN       number) ;';

    dbms_lob.writeappend(v_clob, length(buffer), buffer);

    /* append for raw payload */
    append_to_clob(v_clob, TRUE);

     FOR type_c IN type_cur LOOP
     append_to_clob(v_clob, type_c.schema, type_c.payload_type, TRUE);
   END LOOP;

    dbms_lob.writeappend(v_clob, 21, 'END dbms_aq_wrapper; ');
    dbms_lob.close(v_clob);
    execute immediate v_clob;

    execute immediate 'GRANT EXECUTE ON dbms_aq_wrapper TO PUBLIC';

    dbms_lob.freetemporary(v_clob);
  EXCEPTION
    WHEN OTHERS THEN
    RAISE;
  END generate_dbms_aq;

-------------------------------------------------------------------------------
   /* Generate dbms_aq package body  with enq/deq procedures for all types 
       present in shrd$_type_table */
  PROCEDURE generate_prvt_aq IS

      v_clob           CLOB;
      buffer           VARCHAR2(32767);

      CURSOR type_cur IS
        SELECT * 
        FROM shrd$_type_table;

  BEGIN
    
    dbms_lob.createtemporary(v_clob,true);
    dbms_lob.open(v_clob, dbms_lob.lob_readwrite);
    buffer := ' CREATE OR REPLACE PACKAGE BODY dbms_aq_wrapper AS
       
  current_inst NUMBER := dbms_utility.current_instance;

  PROCEDURE copy_types_enqopt(
              enqueue_options       IN enqueue_options_t,
              eopt                  OUT sys.dbms_aq.enqueue_options_t)IS
  BEGIN
    eopt.visibility := enqueue_options.visibility;
    eopt.relative_msgid:= enqueue_options.relative_msgid;
    eopt.sequence_deviation := enqueue_options.sequence_deviation;
    eopt.transformation := enqueue_options.transformation;
    eopt.bufmesg_prop := enqueue_options.bufmesg_prop;
    eopt.delivery_mode := enqueue_options.delivery_mode;

  END copy_types_enqopt;

 -----------------------------------------------------------------------------

  PROCEDURE copy_types_deqopt(
                 dequeue_options       IN  dequeue_options_t,
                 deopt                 OUT sys.dbms_aq.dequeue_options_t)IS
  BEGIN
    deopt.consumer_name := dequeue_options.consumer_name;
    deopt.dequeue_mode := dequeue_options.dequeue_mode;
    deopt.navigation := dequeue_options.navigation;
    deopt.visibility := dequeue_options.visibility;
    deopt.wait := dequeue_options.wait;
    deopt.msgid := dequeue_options.msgid;
    deopt.correlation := dequeue_options.correlation;
    deopt.deq_condition := dequeue_options.deq_condition;
    deopt.signature := dequeue_options.signature;
    deopt.transformation := dequeue_options.transformation;
    deopt.bufmesg_prop := dequeue_options.bufmesg_prop;
    deopt.delivery_mode := dequeue_options.delivery_mode;
  END copy_types_deqopt;  

 ------------------------------------------------------------------------------

  PROCEDURE copy_types_enqmprop(
                message_properties IN message_properties_t,
                mprop              OUT sys.dbms_aq.message_properties_t) IS

    indx    PLS_INTEGER;

  BEGIN

      mprop.priority := message_properties.priority;
      mprop.delay := message_properties.delay;
      mprop.expiration := message_properties.expiration;
      mprop.correlation := message_properties.correlation;
      mprop.attempts := message_properties.attempts;
      mprop.exception_queue := message_properties.exception_queue;
      mprop.enqueue_time := message_properties.enqueue_time;
      mprop.state := message_properties.state;
      mprop.sender_id := message_properties.sender_id;
      mprop.original_msgid := message_properties.original_msgid;
      mprop.signature := message_properties.signature;
      mprop.transaction_group := message_properties.transaction_group;
      mprop.user_property := message_properties.user_property;
      mprop.delivery_mode := message_properties.delivery_mode;

      indx := message_properties.recipient_list.FIRST;
      WHILE indx IS NOT NULL LOOP
	mprop.recipient_list(indx) := 
			      message_properties.recipient_list(indx);
	indx := message_properties.recipient_list.NEXT(indx);
      END LOOP;

  END copy_types_enqmprop;

-------------------------------------------------------------------------------
  PROCEDURE copy_types_deqmprop(
                mprop              IN sys.dbms_aq.message_properties_t,
                message_properties OUT message_properties_t) IS

    indx    PLS_INTEGER;

  BEGIN

      message_properties.priority := mprop.priority;
      message_properties.delay := mprop.delay;
      message_properties.expiration := mprop.expiration;
      message_properties.correlation := mprop.correlation;
      message_properties.attempts := mprop.attempts;
      message_properties.exception_queue := mprop.exception_queue;
      message_properties.enqueue_time := mprop.enqueue_time;
      message_properties.state := mprop.state;
      message_properties.sender_id := mprop.sender_id;
      message_properties.original_msgid := mprop.original_msgid;
      message_properties.signature := mprop.signature;
      message_properties.transaction_group := mprop.transaction_group;
      message_properties.user_property := mprop.user_property;
      message_properties.delivery_mode := mprop.delivery_mode;

      indx := mprop.recipient_list.FIRST;
      WHILE indx IS NOT NULL LOOP
        message_properties.recipient_list(indx) :=
                              mprop.recipient_list(indx);
        indx := mprop.recipient_list.NEXT(indx);
      END LOOP;
  END copy_types_deqmprop;

 -----------------------------------------------------------------------------

  PROCEDURE copy_types_agent_list(
                agent_list         IN  aq$_agent_list_t,
                agent_list_sys     OUT sys.dbms_aq.aq$_agent_list_t) IS
 
        v_row BINARY_INTEGER;
        canon_q_name         varchar2(30);
        canon_q_schema       varchar2(30);
        phyq                 varchar2(30);
        uflg                 number;
        name1      VARCHAR2(30);
        name2      VARCHAR2(30);
        name3      VARCHAR2(30);
        dblink     VARCHAR2(30);
        nextpos  BINARY_INTEGER;
        sharded    BOOLEAN;

  BEGIN

    v_row := agent_list.FIRST;
    select sys_context(''USERENV'',''current_user'') into canon_q_schema 
    from dual;  
    LOOP
      EXIT WHEN v_row IS NULL;
      dbms_utility.name_tokenize (agent_list(v_row).address, name1,
                                 name2, name3, dblink, nextpos);

      IF(dblink IS  NULL AND agent_list(v_row).address IS NOT NULL) THEN
        IF(name2 IS NULL) THEN
          canon_q_name := name1;
        ELSE
          canon_q_schema := name1;
          canon_q_name := name2;
        END IF;

        maptab_access.sel_maptab(canon_q_schema, canon_q_name, current_inst,
                                 phyq, uflg, sharded);

        agent_list_sys(v_row) := agent_list(v_row);
        IF (sharded = TRUE) THEN
          agent_list_sys(v_row).address := phyq;
        END IF;
      ELSE
        agent_list_sys(v_row) := agent_list(v_row);
      END IF;

      v_row := agent_list.NEXT(v_row);
    END LOOP;

  END copy_types_agent_list;

--------------------------------------------------------------------------------
 PROCEDURE listen(
        agent_list            in     aq$_agent_list_t,
        wait                  in     binary_integer default FOREVER,
        listen_delivery_mode  in     pls_integer DEFAULT PERSISTENT,
        agent                 out    sys.aq$_agent,
        message_delivery_mode out    pls_integer) IS

        agent_list_sys  sys.dbms_aq.aq$_agent_list_t;
    
  BEGIN

     copy_types_agent_list(agent_list, agent_list_sys);
     sys.dbms_aq.listen(agent_list             => agent_list_sys,
                      wait                   => wait,
                      listen_delivery_mode   => listen_delivery_mode,
                      agent                  => agent,
                      message_delivery_mode  => message_delivery_mode);
             
 END listen;

 -----------------------------------------------------------------------------

  PROCEDURE listen(
	agent_list           in     aq$_agent_list_t,
	wait                 in     binary_integer default FOREVER, 
	agent                out    sys.aq$_agent) IS

        agent_list_sys      sys.dbms_aq.aq$_agent_list_t;
            
  BEGIN

    copy_types_agent_list(agent_list, agent_list_sys);
    sys.dbms_aq.listen(agent_list             => agent_list_sys,
          wait                   => wait,
          agent                  => agent);
  END listen;

 -----------------------------------------------------------------------------

 PROCEDURE bind_agent(
           agent                in    sys.aq$_agent,
           certificate_location in    varchar2 default NULL) IS

  BEGIN
   
   sys.dbms_aq.bind_agent(agent => agent,
                               certificate_location => certificate_location);
  END bind_agent;

 -----------------------------------------------------------------------------

 PROCEDURE unbind_agent(
           agent                in   sys.aq$_agent) IS

  BEGIN
   sys.dbms_aq.unbind_agent(agent => agent);
  END unbind_agent;

  PROCEDURE register(
         reg_list      IN       sys.aq$_reg_info_list,
         reg_count     IN       number) IS
  BEGIN
   sys.dbms_aq.register(reg_list => reg_list,
                        reg_count => reg_count);
  END register;


  PROCEDURE unregister(
         reg_list      IN       sys.aq$_reg_info_list,
         reg_count     IN       number) IS

  BEGIN
   sys.dbms_aq.unregister(reg_list => reg_list,
                          reg_count => reg_count);
  END unregister;


  PROCEDURE post(
         post_list     IN       sys.aq$_post_info_list,
         post_count    IN       number) IS
  BEGIN
  sys.dbms_aq.post(post_list => post_list,
                         post_count => post_count);

  END; ' ;

    dbms_lob.writeappend(v_clob, length(buffer), buffer);
 
    /* append for raw payload */
    append_to_clob(v_clob, FALSE);

    FOR type_c IN type_cur LOOP
      append_to_clob(v_clob, type_c.schema, type_c.payload_type, FALSE);
    END LOOP;

    dbms_lob.writeappend(v_clob, 21, 'END dbms_aq_wrapper; ');
    dbms_lob.close(v_clob);
    execute immediate v_clob;
    dbms_lob.freetemporary(v_clob);

  END generate_prvt_aq;
 
 -----------------------------------------------------------------------------
  /* This procedure checks existence of DBMS_AQ_WRAPPER package in 
     wrapperuser */
  PROCEDURE pkg_exist(flg OUT BOOLEAN) IS
    
    row_cnt  NUMBER;

  BEGIN
    SELECT count(*) INTO row_cnt
    FROM user_procedures
    WHERE OBJECT_NAME = 'DBMS_AQ_WRAPPER';
   
    IF(row_cnt = 0) THEN
      flg := FALSE;
    ELSE
      flg := TRUE;
    END IF;
  END pkg_exist;

 ----------------------------------------------------------------------------
 /* Procedure to select queue table storage clause parameters from dba_tables */

  PROCEDURE sel_dbatab(
               schema         IN VARCHAR2,
               q_table        IN VARCHAR2,
               tspace_name    OUT VARCHAR2,
               ini_extent     OUT NUMBER,
               nextextent     OUT NUMBER,
               minextent      OUT NUMBER,
               maxextent      OUT NUMBER,
               pct_incr       OUT NUMBER,
               free_list      OUT NUMBER,
               freelist_grps  OUT NUMBER,
               buffer         OUT VARCHAR2) IS

  BEGIN
     select tablespace_name, initial_extent, next_extent, min_extents,
          max_extents, pct_increase, freelists, freelist_groups, buffer_pool
      into tspace_name,ini_extent, nextextent, minextent, maxextent, pct_incr,
        free_list, freelist_grps, buffer
      from sys.dba_tables
      where owner = schema and table_name = q_table;
  END sel_dbatab;

 ---------------------------------------------------------------------------

END maptab_access;
/
show errors;

